# 機能設計書 31-ffmpeg Mux

## 概要

本ドキュメントは、StaxRipアプリケーションにおけるffmpegを使用した各種コンテナフォーマットへの多重化（Mux）機能の設計を記述する。

### 本機能の処理概要

ffmpeg Mux機能は、エンコード済みのビデオストリームとオーディオストリームを、ffmpegツールを使用して単一のコンテナファイルに多重化する機能である。MKVやMP4のネイティブMuxerでは対応していないAVI、FLV、MOV、TS、MXF等の多様なコンテナフォーマットへの出力を可能にする。

**業務上の目的・背景**：従来のMKV/MP4以外のコンテナフォーマットが必要なワークフローに対応するため、ffmpegの汎用的なMux機能を提供する。特にレガシーシステムとの互換性維持や、放送規格（TS/MXF）、Web配信向けフォーマット（FLV/ISMV）等、多様な出力要件に応えることができる。

**機能の利用シーン**：
- レガシーな再生環境向けにAVIコンテナでの出力が必要な場合
- 放送・業務用途でTS/MXF形式の出力が必要な場合
- Flash動画配信用のFLVファイル作成
- Smooth Streaming用のISMVファイル作成

**主要な処理内容**：
1. 出力フォーマットの選択（ASF、AVI、FLV、ISMV、IVF、MKV、MOV、MP4、MPG、MXF、NUT、OGG、TS、WEBM、WMV）
2. ビデオ入力ファイルの指定とストリームマッピング
3. オーディオトラックの追加とストリームマッピング
4. ffmpegコマンドの構築と実行
5. MOV/MP4/ISMV形式の場合はfaststartフラグの自動付与

**関連システム・外部連携**：ffmpeg外部ツールとの連携が必須。ffmpegはPackage管理システムを通じてパスが解決される。

**権限による制御**：特になし。すべてのユーザーが利用可能。

## 関連画面

| 画面No | 画面名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 1 | MainForm | 参照画面 | lgbEncoderからMuxer選択、プロファイル設定 |
| - | SimpleSettingsForm | 主画面 | ffmpeg Container Optionsダイアログで出力フォーマット選択 |

## 機能種別

データ変換処理 / 外部ツール連携

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | 説明 | バリデーション |
|-------------|-----|-----|------|---------------|
| OutputFormat | String | Yes | 出力コンテナフォーマット | ASF/AVI/FLV/ISMV/IVF/MKV/MOV/MP4/MPG/MXF/NUT/OGG/TS/WEBM/WMVのいずれか |
| VideoEncoderOutputPath | String | Yes | エンコード済みビデオファイルのパス | ファイルが存在すること |
| AudioTracks | List(Of AudioTrack) | No | オーディオトラックのリスト | 各トラックのファイルが存在すること |

### 入力データソース

- p.VideoEncoder.OutputPath: エンコード済みビデオファイル
- p.LastOriginalSourceFile: ビデオエンコーダ出力がない場合のフォールバック
- p.AudioTracks: プロジェクトで設定されたオーディオトラック
- p.TargetFile: 出力先ファイルパス

## 出力仕様

### 出力データ

| 項目名 | 型 | 説明 |
|--------|-----|------|
| TargetFile | ファイル | 指定フォーマットのコンテナファイル |

### 出力先

- p.TargetFile で指定されたパスにコンテナファイルを出力

## 処理フロー

### 処理シーケンス

```
1. 出力フォーマットの確認
   └─ OutputFormatプロパティから出力拡張子を決定

2. ffmpegコマンドライン引数の構築
   └─ -y -hide_banner -probesize 10M オプションの付与

3. ビデオ入力の設定
   └─ エンコーダ出力または元ソースファイルを-iで指定

4. オーディオトラックの追加
   └─ 各オーディオトラックに対してIsSupported確認後、-iで追加

5. ストリームマッピングの設定
   └─ -map 0:v でビデオ、-map N でオーディオをマッピング

6. コーデックコピーの指定
   └─ -c:v copy -c:a copy -strict -2 を付与

7. フォーマット固有オプションの付与
   └─ MOV/MP4/ISMVの場合は -movflags +faststart を付与

8. ffmpegプロセスの実行
   └─ Procクラスを使用してffmpegを実行
```

### フローチャート

```mermaid
flowchart TD
    A[開始] --> B[出力フォーマット確認]
    B --> C[ビデオ入力ファイル確認]
    C --> D{ビデオエンコーダ出力存在?}
    D -->|Yes| E[エンコーダ出力を入力に設定]
    D -->|No| F[元ソースファイルを入力に設定]
    E --> G[オーディオトラック処理ループ]
    F --> G
    G --> H{オーディオトラックあり?}
    H -->|Yes| I[オーディオファイルを入力に追加]
    I --> J[ストリームマッピング追加]
    J --> G
    H -->|No| K[コーデックコピー設定]
    K --> L{MOV/MP4/ISMV?}
    L -->|Yes| M[faststart フラグ追加]
    L -->|No| N[出力ファイル指定]
    M --> N
    N --> O[ffmpeg実行]
    O --> P[終了]
```

## ビジネスルール

### 業務ルール

| ルールNo | ルール名 | 内容 | 適用条件 |
|---------|---------|------|---------|
| BR-31-01 | AVI形式の入力制限 | AVI出力時はサポートされる入力タイプが制限される | OutputFormat = "AVI" |
| BR-31-02 | faststartフラグ | MOV/MP4/ISMVの場合は自動的にfaststartを付与 | OutputFormat in (MOV, MP4, ISMV) |
| BR-31-03 | ストリームコピー | 再エンコードは行わずストリームコピーを使用 | 常時 |

### 計算ロジック

特になし（ストリームコピーのため変換処理なし）

## データベース操作仕様

### 操作別データベース影響一覧

データベース操作なし（ファイルベースの処理）

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| - | ファイル不在 | 入力ビデオファイルが存在しない | 元ソースファイルにフォールバック |
| - | 非対応形式 | オーディオ形式がAVI出力でサポート外 | 該当トラックをスキップ |
| - | ffmpegエラー | ffmpeg実行時のエラー | Procクラスによるエラー表示 |

### リトライ仕様

リトライ処理なし

## トランザクション仕様

ファイル操作のためトランザクション管理なし

## パフォーマンス要件

- ストリームコピーのため、処理時間は入力ファイルサイズに比例
- I/O帯域が主なボトルネック

## セキュリティ考慮事項

- 入力ファイルパスはエスケープ処理を行う
- ffmpegへの引数インジェクション対策として適切なクォート処理

## 備考

- ffmpegの対応バージョンはPackage管理で管理
- 一部フォーマットでは追加のコーデック要件あり

---

## コードリーディングガイド

本機能を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Muxer基底クラスとffmpegMuxerクラスの構造を理解することが重要。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | Muxer.vb | `Source/General/Muxer.vb` | Muxer抽象クラスの定義（12-291行目）、ffmpegMuxerクラス（1009-1120行目） |

**読解のコツ**: VB.NETの継承構造に注目。MuxerがProfileを継承し、ffmpegMuxerがMuxerを継承している。

#### Step 2: エントリーポイントを理解する

ffmpegMuxerのMuxメソッドが処理の起点。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Muxer.vb | `Source/General/Muxer.vb` | ffmpegMuxer.Mux()メソッド（1057-1093行目） |

**主要処理フロー**:
1. **1057行目**: Muxメソッド開始
2. **1058行目**: ffmpegの基本引数設定（-y -hide_banner -probesize 10M）
3. **1060-1064行目**: ビデオ入力ファイルの決定
4. **1069-1079行目**: オーディオトラックの処理ループ
5. **1081行目**: ストリームマッピングとコーデックコピー設定
6. **1082行目**: faststart フラグの条件付き付与
7. **1085-1092行目**: Procクラスによるffmpeg実行

#### Step 3: サポート形式を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Muxer.vb | `Source/General/Muxer.vb` | SupportedFormatsプロパティ（1025-1029行目）、AVITypesプロパティ（1019-1022行目） |

**主要処理フロー**:
- **1025-1029行目**: サポートされる出力フォーマット一覧
- **1019-1022行目**: AVI出力時のサポート入力タイプ

#### Step 4: 編集ダイアログを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | Muxer.vb | `Source/General/Muxer.vb` | ffmpegMuxer.Edit()メソッド（1095-1119行目） |

**主要処理フロー**:
- **1095行目**: SimpleSettingsFormを使用したダイアログ表示
- **1102-1105行目**: 出力フォーマット選択メニューの構築

### プログラム呼び出し階層図

```
MainForm (Muxer選択)
    │
    ├─ ffmpegMuxer.Edit()
    │      └─ SimpleSettingsForm (出力フォーマット選択)
    │
    └─ ffmpegMuxer.Mux()
           │
           ├─ IsSupported() (オーディオ形式チェック)
           │
           └─ Proc (ffmpeg実行)
                  └─ Package.ffmpeg (ffmpegパス解決)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

VideoEncoder.OutputPath ─────▶ ffmpegMuxer.Mux() ─────────────────▶ TargetFile
         or                           │
LastOriginalSourceFile                │
                                      │
AudioTracks ─────────────────────────▶│
    │                                 │
    └─ IsSupported() チェック         │
                                      ▼
                              Proc (ffmpeg実行)
                                      │
                                      ▼
                              コンテナファイル生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| Muxer.vb | `Source/General/Muxer.vb` | ソース | Muxer基底クラスとffmpegMuxerクラスの定義 |
| Package.vb | `Source/General/Package.vb` | ソース | ffmpegパッケージの定義とパス解決 |
| Proc.vb | `Source/General/Proc.vb` | ソース | 外部プロセス実行クラス |
| Project.vb | `Source/General/Project.vb` | ソース | プロジェクト設定（AudioTracks、TargetFile等） |
